<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('prayer_sub_categories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('church_id')->nullable();
            $table->unsignedBigInteger('prayer_category_id')->nullable();
            $table->string('prayer_sub_cat_name')->nullable();
            $table->text('prayer_sub_cat_description')->nullable();
            $table->enum('status', ['Active', 'Inactive'])->default('Active');
            $table->foreign('church_id')->references('id')->on('churches')->onDelete('cascade');
            $table->foreign('prayer_category_id')->references('id')->on('prayer_categories')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('prayer_sub_categories');
    }
};
