
<?php $__env->startSection('content'); ?> 

<div class="app-title">
      <div>
        <h1>
        <i class="fa-light fa-receipt mx-1"></i> Church Management
        </h1>
      </div>
    </div>
    <section class="leavereq-info">
      <div class="container">
        <div class="row">
          <div class="col-md-12">
            <div class="buttons-container">
              <div id="buttons-container"></div>
              <a class="add-emp btn" href="<?php echo e(route('admin.add_church')); ?>"><i class="fa-regular fa-plus"></i> Add New Church</a>
            </div>
          </div>
        </div>
        <div class="row justify-content-center">
          <div class="col-md-12 col-lg-12 col-sm-12 col-xs-12">
            <div class="tile">
              <div class="tile-body">
                <div class="table-responsive">
                  <!-- table start from here -->
                  <table class="table table-hover table-bordered" id="sampleTable">
                    <thead>
                      <tr>
                      <th>S.No.</th>
                        <th>Church Name</th>
                        <th>Denomination</th>
                        <th>Church Logo</th>
                        <th>Status</th>
					              <th>Action</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php if(count($churches) > 0 ): ?>
                          <?php $__currentLoopData = $churches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $church): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><?php echo e($church->church_name ?? ''); ?></td>
                            <td><?php echo e($church->denomination ?? ''); ?></td>
                            <td>
                                <img src="<?php echo e(asset( $church->church_logo)); ?>" alt="Church Logo" width="50" height="50">
                            </td>
                            <td>
                                <?php if($church->status == 'Active'): ?>
                                    <span class="badge badge-success">Active</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">Inactive</span>
                                <?php endif; ?>
                            </td>
                            <td class="flex-td">
                              <a href="<?php echo e(route('admin.edit_church',$church->id )); ?>" class="btn-edit" data-id="1"><i class="fa-regular fa-pen-to-square"></i></a>
                              <a href="<?php echo e(route('admin.delete_church',$church->id )); ?>" class="btn-delete " data-id="1"><i class="fa-regular fa-trash"></i></a>
                            </td>
                          </tr>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                        <tr>
                            <td colspan="6" class="text-center">No Church Added yet,Lets Add Church.</td>
                        </tr>
                        <?php endif; ?>

                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <?php if(session('success')): ?>
    <script>
        Swal.fire({
            icon: 'success',
            title: 'Success!',
            text: "<?php echo e(session('success')); ?>",
            confirmButtonText: 'OK'
        }).then((result) => {
           
        });
    </script>
  <?php endif; ?>

  <?php if(session('error')): ?>
      <script>
          Swal.fire({
              icon: 'error',
              title: 'Oops...',
              text: "<?php echo e(session('error')); ?>",
              confirmButtonText: 'OK'
          });
      </script>
  <?php endif; ?>
  
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp2\htdocs\churchappadmin\resources\views/admin/church.blade.php ENDPATH**/ ?>