@extends('admin.layouts.app')
@section('content')

<div class="app-title">
	<div>
		<h1>
			<i class="fa-regular fa-plus mx-1"></i> Edit New Church
		</h1>
	</div>
</div>

<section class="acc-form">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-lg-8 col-sm-12 col-xs-12 col-md-8">
				<div class="tile">
					<div class="tile-body">

						<form class="emp-master-form" action="{{ route('admin.update_church',$church->id)}}" method="POST" enctype="multipart/form-data">
							@csrf
							<input type="hidden" name="id" value="{{ $church->id }}">
							<div class="row">
								<div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
									<div class="form-group">
										<label class="form-head mb-1" for="name">Church Name:</label>
										<input type="text" class="form-control" name="church_name" id="church_name" value="{{ $church->church_name ?? ''}}" placeholder="Enter Church Name">
									</div>
									@error('church_name')
									<div class="text-danger mt-1">{{ $message }}</div>
									@enderror

								</div>
								<div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
									<div class="form-group">
										<label class="form-head mb-1" for="denomination">Denomination:</label>
										<select name="denomination" id="options" class="form-control">
											<option value="" disabled>Select Denomination</option>
											<option value="Baptist" {{ $church->denomination == 'Baptist' ? 'selected' : '' }}>Baptist</option>
											<option value="AG" {{ $church->denomination == 'AG' ? 'selected' : '' }}>AG</option>
										</select>
									</div>
									@error('denomination')
										<div class="text-danger mt-1">{{ $message }}</div>
									@enderror
								</div>

								<div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
									<div class="form-group">
										<label class="form-head mb-1" for="city">City /District:</label>
										<input type="text" class="form-control" name="city" id="city" value="{{ $church->city ?? '' }}" placeholder="Enter city">
									</div>
									@error('city')
									<div class="text-danger mt-1">{{ $message }}</div>
									@enderror
								</div>
								<div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
									<div class="form-group">
										<label class="form-head mb-1" for="email">State :</label>
										<input type="text" class="form-control" name="state" id="state" value="{{ $church->state ?? ''}}" placeholder="Enter state">
									</div>
									@error('state')
									<div class="text-danger mt-1">{{ $message }}</div>
									@enderror
								</div>
								<div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
									<div class="form-group">
										<label class="form-head mb-1" for="church_logo">Current Church Logo:</label>
										@if($church->church_logo)
										<img src="{{ asset($church->church_logo) }}" alt="Current Church Logo" class="img-fluid" style="max-width: 50px; max-height: 50px;">
										@else
										<p>No logo uploaded yet.</p>
										@endif
									</div>
								</div>
								<div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
									<div class="form-group">
										<label class="form-head mb-1" for="church_logo">Upload New Church Logo:</label>
										<input type="file" class="form-control" name="church_logo" id="church_logo" accept="image/*">
									</div>
									@error('church_logo')
									<div class="text-danger mt-1">{{ $message }}</div>
									@enderror
								</div>
								<div class="col-md-12 col-lg-12 col-sm-12 col-xs-12 mt-4 mb-2">
									<div class="form-group text-center">
										<button class="btn submit-btn w-100" type="submit">
											<i class="fa-sharp fa-light fa-paper-plane mx-2"></i> Update Church </button>
									</div>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

@if (session('success'))
<script>
	Swal.fire({
		icon: 'success',
		title: 'Success!',
		text: "{{ session('success') }}",
		confirmButtonText: 'OK'
	}).then((result) => {
		if (result.isConfirmed) {
			window.location.href = "{{ route('admin.church') }}";
		}
	});
</script>
@endif

@endsection