@extends('admin.layouts.app')
@section('content')
<div class="app-title">
	<div>
		<h1>
			<i class="fa-regular fa-plus mx-1"></i> Add New Leader
		</h1>
	</div>
</div>

<section class="acc-form">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-lg-8 col-sm-12 col-xs-12 col-md-8">
				<div class="tile">
					<div class="tile-body">

						<form class="emp-master-form" action="{{ route('admin.store_leader')}}" method="POST" enctype="multipart/form-data">
							@csrf
							<div class="row">
								<div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
									<div class="form-group">
										<label class="form-head mb-1" for="name">First Name:</label>
										<input type="text" class="form-control" name="first_name" id="first_name" value="{{ old('first_name')}}" placeholder="Enter First Name">
									</div>
									@error('first_name')
									<div class="text-danger mt-1">{{ $message }}</div>
									@enderror
								</div>

								<div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
									<div class="form-group">
										<label class="form-head mb-1" for="name">Last Name:</label>
										<input type="text" class="form-control" name="last_name" id="last_name" value="{{ old('last_name')}}" placeholder="Enter Last Name">
									</div>
									@error('last_name')
									<div class="text-danger mt-1">{{ $message }}</div>
									@enderror
								</div>

								<div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
									<div class="form-group">
										<label class="form-head mb-1" for="email">Email:</label>
										<input type="email" class="form-control" name="email" id="email" value="{{ old('email') }}" placeholder="Enter Email Address">
									</div>
									@error('email')
									<div class="text-danger mt-1">{{ $message }}</div>
									@enderror
								</div>
								<div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
									<div class="form-gro0up">
										<label class="form-head mb-1" for="email">Phone No:</label>
										<input type="tel" class="form-control" name="phone_no" id="phone_no" value="{{ old('phone_no')}}" placeholder="Enter Phone no">
									</div>
									@error('phone_no')
									<div class="text-danger mt-1">{{ $message }}</div>
									@enderror
								</div>

								<!-- Assign Church Dropdown -->
								<div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
									<div class="form-group">
										<label class="form-head mb-1" for="church">Assign Church:</label>
										<select id="options" name="church_id" class="form-control">
											<option value="" disabled {{ old('church_id') ? '' : 'selected' }}>Select Church</option>
											@foreach ($churches as $church)
											<option value="{{ $church->id }}" {{ old('church_id') == $church->id ? 'selected' : '' }}>
												{{ $church->church_name }}
											</option>
											@endforeach
										</select>
									</div>
									@error('church_id')
									<div class="text-danger mt-1">{{ $message }}</div>
									@enderror
								</div>

								<!-- User Role Dropdown -->
								<div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
									<div class="form-group">
										<label class="form-head mb-1" for="user_role">User Role:</label>
										<select id="options" name="user_role" class="form-control">
											<option value="" disabled {{ old('user_role') ? '' : 'selected' }}>Select Role</option>
											<option value="Prayer Warrior" {{ old('user_role') == 'Prayer Warrior' ? 'selected' : '' }}>Prayer Warrior</option>
											<option value="Pastor" {{ old('user_role') == 'Pastor' ? 'selected' : '' }}>Pastor</option>
											<option value="Prayer (Leader)" {{ old('user_role') == 'Prayer (Leader)' ? 'selected' : '' }}>Prayer (Leader)</option>
											<option value="Senior Prayer Warrior (Leader)" {{ old('user_role') == 'Senior Prayer Warrior (Leader)' ? 'selected' : '' }}>Senior Prayer Warrior (Leader)</option>
										</select>
									</div>
									@error('user_role')
									<div class="text-danger mt-1">{{ $message }}</div>
									@enderror
								</div>

								<!-- User Status Dropdown -->
								<div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
									<div class="form-group">
										<label class="form-head mb-1" for="user_status">User Status:</label>
										<select id="options" name="user_status" class="form-control">
											<option value="" disabled {{ old('user_status') ? '' : 'selected' }}>Select Status</option>
											<option value="Prayer Warrior" {{ old('user_status') == 'Prayer Warrior' ? 'selected' : '' }}>Prayer Warrior</option>
											<option value="Champion Warrior" {{ old('user_status') == 'Champion Warrior' ? 'selected' : '' }}>Champion Warrior</option>
											<option value="Elite Warrior" {{ old('user_status') == 'Elite Warrior' ? 'selected' : '' }}>Elite Warrior</option>
											<option value="Inactive User" {{ old('user_status') == 'Inactive User' ? 'selected' : '' }}>Inactive User</option>
										</select>
									</div>
									@error('user_status')
									<div class="text-danger mt-1">{{ $message }}</div>
									@enderror
								</div>

								<div class="col-md-12 col-lg-12 col-sm-12 col-xs-12 mt-4 mb-2">
									<div class="form-group text-center">
										<button class="btn submit-btn w-100" type="submit">
											<i class="fa-sharp fa-light fa-paper-plane mx-2"></i> Send Invitation </button>
									</div>
								</div>
							</div>
						</form>

					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

@if (session('success'))
<script>
	Swal.fire({
		icon: 'success',
		title: 'Success!',
		text: "{{ session('success') }}",
		confirmButtonText: 'OK'
	}).then((result) => {
		if (result.isConfirmed) {
			window.location.href = "{{ route('admin.leaders') }}";
		}
	});
</script>
@endif
@endsection