<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Meeting extends Model
{
    use HasFactory;
    protected $fillable = ['user_id',
    'church_id',
    'meeting_title',
    'meeting_date',
    'meeting_start_time',
    'meeting_end_time',
    'mode_of_meeting',
    'meeting_place',
    'key_prayer_points',
    'prayer_requests',
    'meeting_link',
    'church_prayer_points',
    'theme_prayer_points'];

    // In Meeting.php (Model)
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function church()
    {
        return $this->belongsTo(Church::class);
    }

    protected $casts = [
        'church_prayer_points' => 'array',
        'theme_prayer_points' => 'array',
    ];

}
