
<?php $__env->startSection('content'); ?>     
<?php
    use Illuminate\Support\Str;
?>

<div class="app-title">
      <div>
        <h1>
        <i class="fa-light fa-receipt mx-1"></i> Prayer Points
        </h1>
        <!-- <p>View All Attendance</p> -->
      </div>
    </div>

   

    <section class="leavereq-info">
      <div class="container">
        <div class="row">
          <div class="col-md-12">
            <div class="buttons-container">
              <div id="buttons-container"></div>
              <a class="add-emp btn" href="<?php echo e(route('admin.add_prayer_points')); ?>"><i class="fa-regular fa-plus"></i> Add Prayer Points</a>
            </div>
          </div>
        </div>
        <div class="row justify-content-center">
          <div class="col-md-12 col-lg-12 col-sm-12 col-xs-12">
            <div class="tile">
              <div class="tile-body">
                <div class="table-responsive">
                  <!-- table start from here -->
                  <table class="table table-hover table-bordered" id="sampleTable">

                    <thead>
                    <tr>
                      <th>S.No.</th>
                        <th>Prayer Category</th>
                        <th>Prayer Sub-Category</th>
                        <th>Prayer Point</th>
                        <th>Status</th>
                        <th>Action</th>
                      </tr>
                    </thead>
                    <tbody>
                    <?php if(count($prayer_points) > 0 ): ?>
                          <?php $__currentLoopData = $prayer_points; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prayer_point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><?php echo e($prayer_point->category->prayer_category_name ?? ''); ?></td>
                            <td><?php echo e($prayer_point->subCategory->prayer_sub_cat_name ?? ''); ?></td>
                            <td><?php echo e(Str::words($prayer_point->prayer_point, 8, '...')); ?></td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" class="status-toggle" data-id="<?php echo e($prayer_point->id); ?>" <?php echo e($prayer_point->status == 'Active' ? 'checked' : ''); ?>>
                                    <span class="slider round"></span>
                                </label>
                            </td>     
                           
                            <td class="flex-td">
                              <a href="<?php echo e(route('admin.edit_prayer_point',$prayer_point->id )); ?>" class="btn-edit" data-id="1"><i class="fa-regular fa-pen-to-square"></i></a>
                              <a href="<?php echo e(route('admin.delete_prayer_point',$prayer_point->id )); ?>" class="btn-delete " data-id="1"><i class="fa-regular fa-trash"></i></a>
                            </td>
                          </tr>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                        <tr>
                            <td colspan="6" class="text-center">No Prayer Point Added yet,Lets Add Prayer Point.</td>
                        </tr>
                        <?php endif; ?>
                
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <?php if(session('success')): ?>
    <script>
        Swal.fire({
            icon: 'success',
            title: 'Success!',
            text: "<?php echo e(session('success')); ?>",
            confirmButtonText: 'OK'
        }).then((result) => {
           
        });
    </script>
  <?php endif; ?>

  <?php if(session('error')): ?>
      <script>
          Swal.fire({
              icon: 'error',
              title: 'Oops...',
              text: "<?php echo e(session('error')); ?>",
              confirmButtonText: 'OK'
          });
      </script>
  <?php endif; ?>


<script>
    $(document).on('change', '.status-toggle', function() {
        var status = $(this).prop('checked') ? 'Active' : 'Inactive';
        var prayerPointId = $(this).data('id');
        
        $.ajax({
            url: "<?php echo e(route('admin.prayer_update_status')); ?>",
            type: 'POST',
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            data: {
                
                id: prayerPointId,
                status: status
            },
            success: function(response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Updated!',
                    text: 'Status has been updated successfully.',
                    showConfirmButton: true
                });
            },
            error: function() {
              var errorMessage = xhr.responseJSON.message || 'There was an issue updating the status. Please try again.';
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: errorMessage,
                    showConfirmButton: true
                });          
               }
        });
    });
</script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp2\htdocs\churchappadmin\resources\views/admin/prayer_point.blade.php ENDPATH**/ ?>