<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PrayerSubCategory;
use App\Models\PrayerCategory;
use Exception;

class PrayerSubCategoryController extends Controller
{
    public function PrayerSubCategory(){

        $prayer_sub_categories = PrayerSubCategory::all();
        return view('admin.prayer_sub_category',compact('prayer_sub_categories'));
    }

    public function AddPrayerSubCategory(){

        $prayer_categories = PrayerCategory::all();
        return view('admin.add_prayer_sub_category',compact('prayer_categories'));
    }

    public function StorePrayerSubCategory(Request $request){

        $request->validate([
            'prayer_category_id' => 'required|exists:prayer_categories,id',
            'prayer_sub_cat_name' => 'required|string|max:255|unique:prayer_sub_categories,prayer_sub_cat_name',
            'prayer_sub_cat_description' => 'required|string',
        ]);

        $prayersubcat = new PrayerSubCategory();
        $prayersubcat->prayer_category_id = $request->input('prayer_category_id');
        $prayersubcat->prayer_sub_cat_name = $request->input('prayer_sub_cat_name');
        $prayersubcat->prayer_sub_cat_description = $request->input('prayer_sub_cat_description');    
        $prayersubcat->save();

        return redirect()->back()->with('success','Prayer Sub-Category Added Successfully!');

    }

    public function EditPrayerSubCategory($id){

        $prayer_sub_category = PrayerSubCategory::findOrfail($id);
        $prayer_categories = PrayerCategory::all();
        return view('admin.edit_prayer_sub_category',compact('prayer_sub_category','prayer_categories'));
    }

    public function UpdatePrayerSubCategory(Request $request,$id){
 
        $request->validate([
            'prayer_category_id' => 'required|exists:prayer_categories,id',
            'prayer_sub_cat_name' => 'required|string|max:255|unique:prayer_sub_categories,prayer_sub_cat_name,' . $id,
            'prayer_sub_cat_description' => 'required|string',
        ]);

        $prayersubcat = PrayerSubCategory::findOrFail($id);
        $prayersubcat->prayer_category_id = $request->input('prayer_category_id');
        $prayersubcat->prayer_sub_cat_name = $request->input('prayer_sub_cat_name');
        $prayersubcat->prayer_sub_cat_description = $request->input('prayer_sub_cat_description');
        $prayersubcat->save();
        return redirect()->back()->with('success', 'Prayer Sub-Category Updated Successfully!');
    }

    public function DeletePrayerSubCategory($id){
        try {
            $prayer_sub_category = PrayerSubCategory::find($id);
            if (!$prayer_sub_category) {
                return back()->with('error', 'Prayer Sub Category not found.');
            }
            $prayer_sub_category->delete();
            return back()->with('success', 'Prayer Sub-Category Deleted Successfully');
        } catch (Exception $e) {
            
            return back()->with('error', 'An error occurred while deleting the prayer sub-category.');
        }
    }

   
}
