<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Church;
use App\Models\User;
use App\Models\PrayerPoint;
use App\Models\PrayerLog;

class DashboardController extends Controller
{
    public function Dashboard(){

        $churches_count = Church::count();
        $all_users_count = User::count();
        $prayed_prayer_count = PrayerLog::where('status','Prayed')->count();
        $leader_users_count = User:: where('user_role','!=','Prayer Warrior')->count();

    
        return view('admin.dashboard',compact('churches_count','leader_users_count','all_users_count'));
    }
}
